#############################################################################
# LFS Lapper Utility functions
#############################################################################
# Changes:
# closeButtonRegex - closes buttons for a user that match a regular expression
# closeButtonRegexAll - as above but for all users
# ButtonExists - returns 1 or 0 if a button does/does not exist for a user
# 02/11/2010: 	Added GetMonth function to return the current Month as a text string
# 02/11/2010: 	Added !debug command to print debug messages using DEBUG function
# 02/11/2010: 	Added !am command to send a message to all admins only
# 31/12/2010: 	Added StrReplace function to replace a string within a string
# 01/07/2012: 	Added UserIsAdmin function and aletered login in debug messages
# 15/08/2017: 	Added !deldr & dellr command to delete records from the database
#############################################################################
CatchEvent OnLapperStart()
	# List of LFS Cars...can be reordered or added to
	GlobalVar $LFSCarList;

	$LFSCarList = "UF1,XFG,XRG,LX4,LX6,RB4,FXO,XRT,RAC,FZ5,UFR,XFR,FXR,XRR,FZR,MRT,FBM,FOX,FO8,BF1";

	# Set the DEBUG flag and global var
	GlobalVar $DebugOn;
	$DebugOn = FALSE;
	
	### Global vars for penalty short names ####
	GlobalVar $penalty_shortnames;
	$penalty_shortnames[0] = "--";
	$penalty_shortnames[1] = "DT";
	$penalty_shortnames[2] = "DT";
	$penalty_shortnames[3] = "SG";
	$penalty_shortnames[4] = "SG";
	$penalty_shortnames[5] = "30";
	$penalty_shortnames[6] = "45";
	$penalty_shortnames[7] = "";
    
    GlobalVar $MONTHS;
    $MONTHS[1] = "January";
    $MONTHS[2] = "February";
    $MONTHS[3] = "March";
    $MONTHS[4] = "April";
    $MONTHS[5] = "May";
    $MONTHS[6] = "June";
    $MONTHS[7] = "July";
    $MONTHS[8] = "August";
    $MONTHS[9] = "September";
    $MONTHS[10] = "October";
    $MONTHS[11] = "November";
    $MONTHS[12] = "December";

    GlobalVar $TYRE_TYPES;
	$TYRE_TYPES["TYRE_R1"] = 0;
	$TYRE_TYPES["TYRE_R2"] = 1;
	$TYRE_TYPES["TYRE_R3"] = 2;
	$TYRE_TYPES["TYRE_R4"] = 3;
	$TYRE_TYPES["TYRE_ROAD_SUPER"] = 4;
	$TYRE_TYPES["TYRE_ROAD_NORMAL"] = 5;
	$TYRE_TYPES["TYRE_HYBRID"] = 6;
	$TYRE_TYPES["TYRE_KNOBBLY"] = 7;
	$TYRE_TYPES["TYRE_NUM"] = 8;
    $TYRE_TYPES["TYRE_NO_CHANGE"] = 9;

    GlobalVar $TYRE_TYPE_NUMS;
	$TYRE_TYPE_NUMS[0] = "R1";
	$TYRE_TYPE_NUMS[1] = "R2";
	$TYRE_TYPE_NUMS[2] = "R3";
	$TYRE_TYPE_NUMS[3] = "R4";
	$TYRE_TYPE_NUMS[4] = "SUP";
	$TYRE_TYPE_NUMS[5] = "NOR";
	$TYRE_TYPE_NUMS[6] = "HYB";
	$TYRE_TYPE_NUMS[7] = "KNB";
	$TYRE_TYPE_NUMS[8] = "NUM";
    $TYRE_TYPE_NUMS[9] = "--";

    GlobalVar $TESTARRAY;
	$TESTARRAY[0] = "9";

EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$text = Tolower( $text );
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )

		CASE "!checkdist":
			$PlayerWithLowestDistance = "";
			
			#Set max scanning distance
			$PlayerDistance = 25;
			
			#GetListOfPlayers
			$PlayerList = GetListOfPlayers("");
			
			FOREACH ( $Player IN $ListOfPlayers)
			#You do not need to scan yourself.
				IF(	$Player["value"] != $userName) THEN
					$Distance = TrackUserDistance($userName,$Player["value"]);
					#When current player is having a lower distance than PlayerDistance
					IF ($Distance <= $PlayerDistance) THEN
						$PlayerWithLowestDistance = GetPlayerVar($Player["value"],"UserName");
						$PlayerDistance = $Distance;
					ENDIF
				ENDIF
			ENDFOREACH
			Privmsg("Player with lowest distance: ".$PlayerWithLowestDistance);
			Privmsg("Distance: ".$PlayerDistance);	
		BREAK;
		
		CASE "!am":
			AdminMsg($argv);
		BREAK;
		
		CASE "!layoutlist":
		CASE "!ll":
			IF (UserIsAdmin($userName) == 1) THEN
				LayoutList($argv,"LAYOUTNAME","ASC");
			ENDIF
		BREAK;
		CASE "!deletedriftrecord":
		CASE "!deldr":
			IF (UserIsAdmin($userName) == 1) THEN
			#Delete 1 record: !ddr Username/Car 
			#Delete specific car: !ddr -/Car
			#Delete specific player: !ddr Username/-
			
			IF ($argv != "") THEN
				$Array = SplitToArray($argv,",");
				$UserName 	= 	$Array[0];
				$Car 		= 	$Array[1];
			ELSE
				#All records of current trackconfig will be deleted
				$Array[0] = "-"; 
				$Array[1] = "-";
			ENDIF
			privmsg("debug: ".$Array[0].",".$Array[1]."");
			deletedriftrecords($Array[0],$Array[1]);
			ENDIF
		BREAK;
		
		CASE "!deletelaprecord":
		CASE "!dellr":
			IF (UserIsAdmin($userName) == 1) THEN
			#Delete 1 record: !dellr Username/Car 
			#Delete specific car: !dellr -/Car
			#Delete specific player: !dellr Username/-
			
			IF ($argv != "") THEN
				$Array = SplitToArray($argv,",");
				$UserName 	= 	$Array[0];
				$Car 		= 	$Array[1];	
			ELSE
			#All records of current trackconfig will be deleted
				$Array[0] = "-"; 
				$Array[1] = "-";
			ENDIF
			privmsg("debug: ".$Array[0].",".$Array[1]."");
			deletelaptimerecords($Array[0],$Array[1]);
			ENDIF
		BREAK;
		
		CASE "!gl":
			getlistoflayouts();
		BREAK;
		
		CASE "!sort":
			$list = getlisttopdrift( $argv,FALSE,FALSE ); #Get List from database
			$getlist = Sort($list,"ASC"); 
			$Count_GetNumber = arrayCount( $getlist );
				
			privmsg("^3Sorted ArrayList");
			FOR ($i=0;$i<=10;$i=$i+1)
				privmsg($i. ": ".$getlist[$i]);
			ENDFOR
		BREAK;
			
		CASE "!li":
			layoutinfo();
		BREAK;
		CASE "!debug":
			IF ( GetUserStoredNum ("DebugOn") == 1 )
			THEN
				SetUserStoredValue ( "DebugOn", 0 );
				privMsg ( "DEBUG messages are now ^3OFF" );
			ELSE
				SetUserStoredValue ( "DebugOn", 1 );
				privMsg ( "DEBUG messages are now ^3ON" );
			ENDIF
		BREAK;
		
		DEFAULT:
				
		BREAK;
	ENDSWITCH
EndCatchEvent

# For use in debugging scripts, use !debug command to turn debugging on
# then call this Sub using: DEBUG("This is a debug message");
Sub DEBUG ($msg)
	$ListOfPlayers = GetListOfPlayers("N");
	FOREACH ( $Player IN $ListOfPlayers)
		IF ( UserIsAdmin( $Player["value"] ) == 1 )
		THEN
			IF ( GetUserStoredNum ($Player["value"], "DebugOn") == 1 )
			THEN
				privMsg( $Player["value"], "^7DEBUG: ^8" . $msg );
			ENDIF
		ENDIF
	ENDFOREACH
EndSub

# Send a message to all ADMINS on the admin channel using: ADMIN("This is an admin only message");
Sub ADMIN ( $msg )
	AdminMsg ( $msg )
EndSub

Sub AdminMsg ( $msg )
	$lop = getListOfPlayers( $userName );
    FOREACH ( $de in $lop )
        $userName = $de["value"];
        IF ( UserIsAdmin( $userName ) == 1 )
		THEN
			privMsg( $userName,"^7ADMIN: ^8" . $msg );
		ENDIF
	ENDFOREACH
EndSub

Sub closeButtonRegex ( $userName, $exp )
	$lob = getListOfPlayerButtons( $userName );
    FOREACH ( $de in $lob )
        $nameOfButton = $de["value"];
        IF ( isRegexMatch( $exp, $nameOfButton ) == 1 ) THEN
            closeButton ( $userName, $nameOfButton );
        ENDIF
	ENDFOREACH
EndSub

Sub closeButtonRegexAll ( $exp )
    $LoP = GetListOfPlayers( );
    FOREACH ( $Pid IN $LoP )
    closeButtonRegex ($Pid["value"], $exp);
    ENDFOREACH
EndSub
  
Sub ButtonExists( $userName, $ButtonToFind )
	$lob = getListOfPlayerButtons( $userName );
    FOREACH ( $de in $lob )
        $nameOfButton = $de["value"];
        IF ( isRegexMatch( $ButtonToFind, $nameOfButton ) == 1 ) THEN
            return(1);
        ENDIF
	ENDFOREACH
	return(0);
EndSub

Sub DialogCreateCentered ( $userName, $DialogPrefix, $Width, $Height, $Title, $showClose, $secondsDisplayed) #$origL & $origT are no longer needed up here
	$origL = round(ToNum(ToNum(200 - $Width)/2),0);
	$origT = round(ToNum(ToNum(200 - $Height)/2),0);

	DialogCreate ( $userName, $DialogPrefix, $origL, $origT, $Width, $Height, $Title, $showClose, $secondsDisplayed);
EndSub

Sub DialogCreate ( $userName, $DialogPrefix, $origL, $origT, $Width, $Height, $Title, $showClose, $secondsDisplayed)
	# Draw window titles with Prev, Next and Close buttons
	openButton ( $userName, $DialogPrefix . "_bg1",$origL-1,$origT-7,$Width+2,$Height+9,1,$secondsDisplayed,ISB_DARK,"");
	openButton ( $userName, $DialogPrefix . "_title",$origL,$origT-6,$Width,5,5,$secondsDisplayed,ISB_LEFT,"^7" . $Title );
	openButton ( $userName, $DialogPrefix . "_bg2",$origL,$origT,$Width,$Height,1,$secondsDisplayed,ISB_LIGHT,"");

	IF ( $showClose == true )
	THEN
		openButton ( $userName, $DialogPrefix . "_close",87,$origT+$Height+1,27,6,8,$secondsDisplayed,ISB_LIGHT,"^0[  Close  ]",DialogClose );
	ENDIF

	# Draw the main contents window on top of the titles
	openButton ( $userName, $DialogPrefix . "_contents_bg",$origL,$origT,$Width,$Height,1,-1,ISB_DARK,"");
	#	openButton ( $userName, $DialogPrefix . "_contents_bg",$origL,$origT,$Width,$Height,1,-1,ISB_LIGHT,"");

EndSub

Sub DialogClose ( $KeyFlags, $id )
	$currPly = GetPlayerInfo();
	$DialogPrefix = split( $id,"_",0 );
	DEBUG ("Closing dialogs " . $DialogPrefix );
	closeButtonRegex ($currPly["UserName"], $DialogPrefix . ".*");
EndSub

Sub SpecAll()
	$LoP = GetListOfPlayers( );  				
	FOREACH ( $Pid IN $LoP )
		IF ( GetPlayerVar( $Pid["value"], "OnTrack" ) == "1" )
		THEN
			cmdLFS( "/spec " . $Pid["value"] );
		ENDIF
	ENDFOREACH
EndSub

Sub GetMonth()
    $date = getLapperVar("ShortDate");    # Get date in dd/mm/yyyy format
    return ($MONTHS[ToNum((substr($date, 3, 2)))]);        # Strip the month from the short date
EndSub

# Replace a string within a string
Sub StrReplace( $String, $Find, $Replace )
	$DONE = FALSE;
	$NewString = $String;
	WHILE ( $DONE == FALSE )
		$FindIndex = indexOf($NewString, $Find);
		IF ( $FindIndex == -1 )
		THEN
			$DONE = TRUE;
		ELSE
			$Split1 = subStr( $NewString ,0, $FindIndex );
			$SplitMid = strLen($Split1) + strLen($Find);
			$Split2 = subStr( $NewString ,$SplitMid, strLen($NewString) - $SplitMid );
			$NewString = $Split1 . $Replace . $Split2;
		ENDIF
	ENDWHILE
	return ($NewString);
EndSub

Sub AllRacersFinished ()
	$haveAllRacersFinished = TRUE;
	$thisLOP = GetListOfPlayers("N");
	FOREACH ( $Player IN $thisLOP)
#		DEBUG ("Checking result for: " . $Player["value"] . " = " . GetPlayerVar($Player["value"], "FinishedPos") );
		IF ( ToNum(GetPlayerVar($Player["value"], "FinishedPos")) < 0 && ToNum(GetPlayerVar($Player["value"], "OnTrack")) == 1)
		THEN
			DEBUG ("Player has yet to finish race: " . $Player["value"] );
			$haveAllRacersFinished = FALSE;
		ENDIF
	ENDFOREACH
	return ( $haveAllRacersFinished );
EndSub

Sub UserIsAdmin($userName)
	UserGroupFromFile( "superusers", "./superusers.txt" );
	IF ( UserIsServerAdmin( $userName ) == 1 ||  GetPlayerVar($userName,"UCID") == 0 ||  UserInGroup( "superusers",$userName) == 1 )
	THEN
		return(ToNum(1));
	ELSE
		return(ToNum(0));
	ENDIF
EndSub
